"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHomeDir = void 0;
const os_1 = require("os");
const path_1 = require("path");
const process_1 = require("process");
const homeDirCache = {};
const getHomeDirCacheKey = () => {
    if (process_1.geteuid) {
        return `${(0, process_1.geteuid)()}`;
    }
    return "DEFAULT";
};
const getHomeDir = () => {
    const { HOME, USERPROFILE, HOMEPATH, HOMEDRIVE = `C:${path_1.sep}` } = process.env;
    if (HOME)
        return HOME;
    if (USERPROFILE)
        return USERPROFILE;
    if (HOMEPATH)
        return `${HOMEDRIVE}${HOMEPATH}`;
    const homeDirCacheKey = getHomeDirCacheKey();
    if (!homeDirCache[homeDirCacheKey])
        homeDirCache[homeDirCacheKey] = (0, os_1.homedir)();
    return homeDirCache[homeDirCacheKey];
};
exports.getHomeDir = getHomeDir;
